package com.javaworld.geekcap.mockito;

import static org.mockito.Mockito.atLeastOnce;
import static org.mockito.Mockito.never;
import static org.mockito.Mockito.times;
import static org.mockito.Mockito.verify;

import java.util.ArrayList;
import java.util.List;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Spy;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(MockitoExtension.class)
public class SimpleSpyTest {
    @Spy
    List<String> stringList = new ArrayList<>();

    @Test
    public void testStringListAdd() {
        // Add an item to the list and verify that it has one element
        stringList.add("One");
        Assertions.assertEquals(1, stringList.size());

        // Add another item to the list and verify that it has two elements
        stringList.add("Two");
        Assertions.assertEquals(2, stringList.size());

        // Verify that add was called with arguments "One" and "Two"
        verify(stringList).add("One");
        verify(stringList).add("Two");

        // Verify that add was never called with an argument of "Three"
        verify(stringList, never()).add("Three");

        // Verify that the size() method was called twice
        verify(stringList, times(2)).size();

        // Verify that the size() method was called at least once
        verify(stringList, atLeastOnce()).size();
    }
}
