package com.javaworld.geekcap.mockito;

import static org.junit.jupiter.api.Assertions.fail;
import static org.mockito.Mockito.spy;
import static org.mockito.Mockito.verify;

import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;

import com.javaworld.geekcap.mockito.Repository;
import com.javaworld.geekcap.mockito.Service;

import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(MockitoExtension.class)
public class SpyAndMockTest {
    // Create a Mock of a spied Repository
    @Mock
    Repository repository = spy(new Repository());

    // Inject the respository into the service
    @InjectMocks
    Service service;

    @Test
    public void verifyRepositoryGetStuffIsCalled() {
        try {
            // Setup mock scenario
            Mockito.when(repository.getStuff()).thenReturn(Arrays.asList("A", "B", "CDEFGHIJK", "12345", "1234"));
        } catch (SQLException e) {
            fail(e.getMessage());
        }

        // Execute the service that uses the mocked repository
        List<String> stuff = service.getStuffWithLengthLessThanFive();

        // Validate the response
        Assertions.assertNotNull(stuff);
        Assertions.assertEquals(3, stuff.size());

        try {
            // Verify that the repository getStuff() method was called
            verify(repository).getStuff();
        } catch (SQLException e) {
            fail(e.getMessage());
        }
    }
}
