package com.infoworld.widgetservice.service;

import java.util.List;
import java.util.Optional;

import com.infoworld.widgetservice.model.Widget;
import com.infoworld.widgetservice.repository.WidgetRepository;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WidgetService {
    @Autowired
    private WidgetRepository widgetRepository;

    public List<Widget> findAll() {
        return widgetRepository.findAll();
    }

    public Optional<Widget> findById(Long id) {
        return widgetRepository.findById(id);
    }

    public Widget create(Widget widget) {
        widget.setVersion(1);
        return widgetRepository.save(widget);
    }

    public Widget save(Widget widget) {
        return widgetRepository.save(widget);
    }

    public void deleteById(Long id) {
        widgetRepository.deleteById(id);
    }
}
