package com.infoworld.widgetservice.service;

import static org.junit.jupiter.api.Assertions.assertEquals;
import static org.junit.jupiter.api.Assertions.assertTrue;
import static org.mockito.Mockito.when;

import java.util.Optional;

import com.infoworld.widgetservice.model.Widget;
import com.infoworld.widgetservice.repository.WidgetRepository;

import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.junit.jupiter.MockitoExtension;

@ExtendWith(MockitoExtension.class)
public class WidgetServiceTest {
    @Mock
    private WidgetRepository repository;

    @InjectMocks
    private WidgetService service;

    @Test
    void testFindById() {
        Widget widget = new Widget(1L, "My Widget", 1);
        when(repository.findById(1L)).thenReturn(Optional.of(widget));

        Optional<Widget> w = service.findById(1L);
        assertTrue(w.isPresent());
        assertEquals(1L, w.get().getId());
        assertEquals("My Widget", w.get().getName());
        assertEquals(1, w.get().getVersion());
    }
}
