package com.infoworld.springaidemo.service;

import java.util.Map;

import com.infoworld.springaidemo.model.JokeResponse;
import com.infoworld.springaidemo.model.SimpleQueryResponse;

import org.springframework.ai.chat.client.ChatClient;
import org.springframework.ai.chat.prompt.Prompt;
import org.springframework.ai.chat.prompt.PromptTemplate;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Service;

@Service
public class SpringAIService {

    @Value("classpath:/templates/joke-template.st")
    private Resource jokeTemplate;

    private final ChatClient chatClient;

    public SpringAIService(ChatClient.Builder chatClientBuilder) {
        this.chatClient = chatClientBuilder.build();
    }

    public String simpleQueryAsString(String query) {
        return this.chatClient.prompt(query).call().content();
    }

    public SimpleQueryResponse simpleQuery(String query) {
        return this.chatClient.prompt(query).call().entity(SimpleQueryResponse.class);
    }

    public JokeResponse tellMeAJoke(String type, String topic) {
        Prompt prompt = new PromptTemplate(jokeTemplate)
                .create(Map.of("type", type, "topic", topic));
        return this.chatClient.prompt(prompt).call().entity(JokeResponse.class);
    }


}
