package com.infoworld.springaidemo.web;

import com.infoworld.springaidemo.model.JokeRequest;
import com.infoworld.springaidemo.model.JokeResponse;
import com.infoworld.springaidemo.model.SimpleQuery;
import com.infoworld.springaidemo.model.SimpleQueryResponse;
import com.infoworld.springaidemo.service.SpringAIService;

import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class SpringAiController {
    private final SpringAIService springAIService;

    public SpringAiController(SpringAIService springAIService) {
        this.springAIService = springAIService;
    }

    @PostMapping("/simpleQuery")
    public ResponseEntity<SimpleQueryResponse> simpleQuery(@RequestBody SimpleQuery simpleQuery) {
        SimpleQueryResponse response = springAIService.simpleQuery(simpleQuery.query());
        return ResponseEntity.ok(response);
    }

    @PostMapping("/tellMeAJoke")
    public ResponseEntity<JokeResponse> tellMeAJoke(@RequestBody JokeRequest jokeRequest) {
        JokeResponse response = springAIService.tellMeAJoke(jokeRequest.type(), jokeRequest.topic());
        return ResponseEntity.ok(response);
    }
}
